---
title: Lecture 2：函数的概念及常见函数
tags:
  - 数学
  - "#函数"
categories: 
date: 2024-02-26
---
---
## 2.1 函数的基本概念
### 2.1.1 函数的定义
##### **定义**： #函数
> <font color="#ccc1d9">描述：</font>如果对于每个数 $x\in D$ ，变量 $x$ 按照一定的法则总有一个确定的 $y$ 和它对应，则称 $x$ 是 $y$ 的函数，记为 $y=f(x)$；常称 x 为自变量，$y$ 为因变量，$D$ 为定义域.

**解释**
+ 基本概念
	+ 定义域：$D_f=D.$
	+ 值域：$R_f=f(D)=\{y|y=f(x),x\in D\}$
+ 函数的两个基本要素：
	+ 定义域
	+ 对应规则
+ 只要满足两个要素，则可称两个函数相同，不用管定义域用什么符号； 
+ 注意：
	+ 一个 $x$ 只能对应一个 $y$
	+ 例如 $y^2=x$ 就不是函数，因为一个 $x$ 对应两个 $y.$

### 2.1.2 其他函数类型
**取整函数**
+ 设 $x$ 为任意实数，不超过 x 的最大整数称为的整数部分，记为 $[x].$ 
+ 函数 $y=[x]$ 称为取整函数；

## 2.2 其他常见函数
### 2.2.1 复合函数
##### **定义**： #复合函数
> <font color="#ccc1d9">描述：</font>设 $y=f(u)$ 的定义域为 $D_f，u=g(x)$ 的定义域为 $D_g$ 、值域为 $R_{s}$ ；若 $D_f\cap R_g\neq\phi,\text{则称函数}y=f[g(x)]$ 为函数 $y=f(u)$ 与 $u=g(x)$ 的复合函数. 它的定义域为 $\left\{x|x\in D_g,g(x)\in D_f\right\}$；

**解释**
+ g：内层函数
+ f：外层函数
+ 核心：$D_f\cap R_g\neq\phi$

**方法：判断两个函数是否复合**
+ 内层函数的值域和外层函数的定义域的相交，必须是一个非空集合；不然就不是复合函数；

**易错点**：注意复合函数中的值域与定义域 
+ 概念： 
	+ 内层函数的**值域**，是复合函数的**定义域**
+ 易错点：
	+ 把内层函数的定义域当成复合函数的定义域；

### 2.2.2 反函数
##### **定义**： #反函数
> <font color="#ccc1d9">描述：</font>设函数 $y=f(x)$ 的定义域为 ${D}$, 值域为 $\underline{R}_{\underline{\nu}}$.若对任意 $y\in R_y$ ,有唯一确定的 $x\in D$ ,使得 $y=f(x)$,则记为 $x=f^{-1}(y)$ 称其为函数 $y=f(x)$ 的反函数；

**解释**
+ 普通函数：多个 x 可以对应成一个 y；
+ 反函数：一个 x 只能对应成一个 y；
+ 概念：
	+ 1. $\text{有时也将}\quad y=f(x)\text{ 的反函数 }x=f^{-1}(y)\text{ 写成 }y=f^{-1}(x)$
	+ 2. $\text{在同一直角坐标系中,}y=f(x)\text{ 和 }x=f^{-1}(y)\text{ 的图形重和}$；
	+ 3. $y=f(x)\text{ 和 }y=f^{-1}(x)\text{ 的图形关于直线 }y=x\text{ 对称}$；

**方法：是否有反函数**
+ 核心：
	+ 1. 对任意 $y\in R_y$ 是否有唯一确定的 $x\in D$；
	+ 2. 单调函数一定有反函数；
	+ 3. 反函数不一定是单调函数；
+ 比如：
	+ $y=x^3$ 有反函数，而 $y=x^2$ 没有；
+ 结论：
	+ 对 $\forall x_{1}\neq x_{2}\in D\Rightarrow f(x_{1})\neq f(x_{2})$
	+ 即 f 函数应该是一个一一对应的映射；

**方法：求一个函数的反函数**
+ 例：$\text{求函数 }y=\mathbf{sh}x=\frac{e^x-e^{-x}}2\text{ 的反函数}.$
+ 具体步骤：
	+ 1. 求出反解；
	+ 2. 将函数 y、x 对调；
### 2.2.3 反函数和复合函数结合
**两者结合**：
+ 情况一： $f^{-1}[f(x)]=x$
	+ 普通函数传入到当前函数的反函数当中
+ 情况二： $f[f^{-1}(x)]=x$

## 2.3 初等函数
### 2.3.1 基本初等函数定义
##### **定义**： #基本初等函数
> <font color="#ccc1d9">描述：</font>将幂函数、指数、对数、三角函数、反三角函数统称为基本初等函数；
> 

**解释**
![[Pasted image 20240226231300.png]]

##### **定义**： #初等函数
> <font color="#ccc1d9">描述：</font>由
> 1. 常数和五类基本初等函数构成；
> 2. 进行的加减乘除以及复合
> 3. 所得到的用一个解析式表达的函数
> 称之为初等函数；

## 2.4 常考题型
### 题型： #复合函数
#### PART 1：解题方法
**考法：如果是分段函数的复合**
+ 1. 依然是内层带入到外层；
+ 2. 如果是分段时，需要根据内函数的分段（**内函数的函数值，落到了外函数的哪个部分**），分段的将内函数带入到对应的外函数中；
**考法：如果是已知复核后的函数以及外层函数，要求内层函数**
+ 1. 将复合函数的结果=外层函数套进内层函数后得到的函数；
#### PART 2：典型例题
**例题**：$\text{设 }g(x)=\begin{cases}2-x,&x\leq0,\\x+2,&x>0,\end{cases}f(x)=\begin{cases}x^2,&x<0,\\-x,&x\geq0,&\end{cases}\text{则 }g[f(x)]=(\quad)$
